#################################################
#A function to estimate the number of bears    #
#disturbed from proposed activities            #
################################################
disturbance.func.parallel.FLIRvar.narwhal=function(dens=sim.dens[[1]],
                                           prob.resp.estab = c(0.750, 0.250, 0.000, 0.000), # None, levB, LevA, Lethal
                                           prob.resp.early = c(0.860, 0.000, 0.000, 0.140), # None, LevB, LevA, Lethal
                                           prob.resp.late  = c(0.510, 0.000, 0.490, 0.000), # None, LevB, LevA, Lethal
                                           prob.resp.post  = c(0.000, 0.200, 0.800, 0.000), # None, LevB, LevA, Lethal
                                           prob.resp.post2 = c(0.000, 0.474, 0.526, 0.000), # None, LevB, LevA, Lethal#If disturbed during late denning, prob of being disturbed during post emergence
                                           dev.obj,           # owin of all unbuffered dev objects combined
                                           dev.obj.list,      # assumes dev.obj has been consolidated to unique dates using combine.compact.feature()
                                           dev.obj.list.buff, # buffered set of owins for each unique date for faster computing time, created after combine.compact.feature() run
                                           dev.obj.dates,     # data frame of dates corresponding to the above 2 lists  MUST have columns named "start", "end"
                                           FLIR = T,          # Include FLIR T/F
                                           FLIR.regions = flir.owin.list,  # list of owin objects corresponding to flir sessions
                                           FLIR.dates,                     # data frame with start and end column to match elements of flir.owin.list
                                           min.days.between.flir = 1,
                                           FLIR.detec.prob  = data.frame(x=flir3),
                                           litter.surv.coef = surv.param,   #samples from parameter estimates used for litter survival calculation 
                                           disturbance.distance       = 1610,    #buffer distance for all den periods other than early
                                           disturbance.distance.early = 805 ){   #buffer distance for early period only
  
  
  require(raster)
  require(spatstat)
  require(foreach)
  require(doParallel)
  
  len=dim(dens)[1]          #get number of dens for making results.df below
  
  if(sum(names(dev.obj.dates) %in% c("start", "end")) != 2) stop("the names of the dev.obj.dates are not (start end), which will crash function")           #make check because some data come with years appended to the names--simply rename the object!
  
  
  #create df to store results
  results.df=data.frame(LevB.estab.bears     =NA,
                        LevB.early.bears     =NA,
                        Lethal.early.ndens   =NA,
                        Lethal.early.ncubs   =NA,
                        LevB.late.bears      =NA,
                        LevA.late.ndens      =NA,
                        LevA.late.ncubs      =NA,
                        Lethal.late.ndens    =NA,
                        Lethal.late.ncubs    =NA,
                        LevB.post.bears      =NA,
                        LevA.post.ndens      =NA,
                        LevA.post.ncubs      =NA,
                        Lethal.post.ndens    =NA,
                        Lethal.post.ncubs    =NA,
                        P.Litter.Surv.undist =NA,
                        P.Litter.Surv.dist   =NA,
                        P.Litter.Surv.delta  =NA   )
  
  

    #################################################
    #Determine min dist to each infrastructure layer#
    #################################################
    #convert dens into ppp object
    dens.ppp = ppp(dens$x,dens$y,window=owin(xrange=range(dens$x),yrange=range(dens$y)))

    dev.dist.fun          = distfun.owin(dev.obj)
    dens$d2dev       = dev.dist.fun(dens.ppp)
    dens$d2dev.estab =NA
    dens$d2dev.early =NA
    dens$d2dev.late  =NA
    dens$d2dev.post  =NA

    #####################################
    #Determine if exposed to disturbance#
    #####################################
    dens$exposed.dev       = 0
    dens$exposed.early.dev = 0
    dens[dens$d2dev<disturbance.distance      , 'exposed.dev'      ] = 1
    dens[dens$d2dev<disturbance.distance.early, 'exposed.early.dev'] = 1
    ########################################
    #Determine if disturbed due to exposure#
    ########################################
    dens$disturbed.estab =NA
    dens$disturbed.early =NA
    dens$disturbed.late  =NA
    dens$disturbed.post  =NA

    #######################################
    #Determine class of take from exposure#
    #######################################
    dens$disturbed.estab.LevB   =NA
    dens$disturbed.early.Lethal =NA
    dens$disturbed.late.LevB    =NA
    dens$disturbed.late.LevA    =NA
    dens$disturbed.late.Lethal  =NA
    dens$disturbed.post.LevB    =NA
    dens$disturbed.post.LevA    =NA
    dens$disturbed.post.Lethal  =NA

    #######################################
    #Determine new emergence/dep dates    #
    #######################################
    dens$disturbed.emerge.date =NA
    dens$disturbed.dep.date    =NA
    class(dens$disturbed.emerge.date) = class(dens$entrance.date) #make them POSIX
    class(dens$disturbed.dep.date   ) = class(dens$entrance.date)
    dens$disturbed.tad        =NA
    dens$P.Litter.Surv.undist =NA #holds undisturbed litter survival prob
    dens$P.Litter.Surv.dist   =NA #holds disturbed   litter survival prob

    ############################################
    #FLIR
    ############################################
    #Determine if dens are discovered by FLIR

    #Keep track of whether dens were detected or not
    dens$detected.flir =NA
    dens$detected.date =NA
    
    if(FLIR==T){
      
      #Keep track of FLIR dates
      FLIR.date = rep(NA,length(FLIR.regions))
      class(FLIR.date) = class(dens$birth.date)
      
      ############################
      #Randomly choose FLIR dates#
      ############################
      for(f in 1:length(FLIR.regions)){
        FLIR.date[f] = sample(seq(FLIR.dates[f,1],FLIR.dates[f,2],60*60*24),1)      #perhaps try this, should save time
      }
      
      #####################################################
      #Determine which dens were detected by FLIR and when#
      #####################################################
      
      class(dens$detected.date) = class(dens$birth.date)
      
      #FLIR for all infrastructure within the disturbance distance and within a given FLIR survey area:
      for(f in 1:length(FLIR.regions)){
        tmp.which = which(dens$entrance.date<=FLIR.date[f] & dens$exposed.dev==1 & inside.owin(dens$x,dens$y,FLIR.regions[[f]]) & 
                            !Vectorize(isTRUE)(dens$detected.flir==1)) #Vectorize(isTRUE)() will return FALSE for NA, so this is everything that hasn't been detected
        tmp.flir = rbinom(length(tmp.which),1,sample(FLIR.detec.prob[,1],1))
        dens$detected.flir[tmp.which] = tmp.flir
        tmp.which2 = which(Vectorize(isTRUE)(dens$detected.flir==1) & is.na(dens$detected.date))
        dens$detected.date[tmp.which2] = FLIR.date[f]
      } 
    }# end if FLIR==T
    ####################################################################################################################################
    ####################################################################################################################################  
    
    ########################    
    #Apply disturbance from#    
    #Different activities  #
    #and infrastructure    #    
    ########################    
    #Determine those disturbed by development during den establishment
    
    # which.exposed.dev = which(dens$exposed.dev==1 & is.na(dens$disturbed.estab.LevB))  #dens that were evaluated for disturbance during FLIR and not disturbed are not included
    which.exposed.dev = which(dens$exposed.dev==1)  #no longer have FLIR disturbance, so all exposed dens eligible for disturbance
    if(length(which.exposed.dev) > 0){
      for(d in 1:length(which.exposed.dev)){
        
        #Which development were active during den establishment period for a given den
        if( Vectorize(isTRUE)(dens$detected.flir[which.exposed.dev[d]]==1)){                  #cases where detected by FLIR (and dev prior to FLIR detection)                             
          which.dev=which( dev.obj.dates$start <= dens$birth.date[which.exposed.dev[d]] & dev.obj.dates$end   >= dens$entrance.date[which.exposed.dev[d]]  &   #starts on or before birth,  ends on or after  entrance                   
                            dev.obj.dates$start <= dens$detected.date[which.exposed.dev[d]])                                                                    # start of development prior to Flir detection (for projects that run year round)
        } else {    #all other cases 
          which.dev=which( dev.obj.dates$start <= dens$birth.date[which.exposed.dev[d]] & dev.obj.dates$end   >= dens$entrance.date[which.exposed.dev[d]]  )   #starts on or before birth,  ends on or after  entrance                   
        }
        
        exposed = 0
        count = 1
        while( count<=length(which.dev)){  
          if(inside.owin(dens.ppp[which.exposed.dev[d]]$x,dens.ppp[which.exposed.dev[d]]$y,dev.obj.list.buff[[which.dev[count]]])==T) {exposed=1; break }
          count = count+1
        }
        
        #If den exposed to activity, then assign take
        if(exposed==1){
          dens$d2dev.estab[which.exposed.dev[d]]=disturbance.distance  
          take.level=which(rmultinom(1,1,prob.resp.estab)==1)
          if(take.level==1){
            # dens$disturbed.estab.LevB[which.exposed.dev[d]] = 0 #no need to assign values, can be left as NA to save computing time
            # dens$disturbed.estab     [which.exposed.dev[d]] = 0
          }else{
            dens$disturbed.estab.LevB[which.exposed.dev[d]] = 1
            dens$disturbed.estab     [which.exposed.dev[d]] = 1
          }
        } else dens$d2dev.estab[which.exposed.dev[d]]=9999  #end if exposed
      } #end for d loop through exposed dens
    }
    ########################################################################################################################################################
    
    #Determine those disturbed by development during early denning period
    not.detected = (! ( Vectorize(isTRUE)(dens$detected.flir==1) & dens$birth.date > dens$detected.date) )    # not detected by FLIR and birth date after detected date

    which.exposed.dev = which(dens$exposed.early.dev==1 & not.detected==T ) 
    
    if(length(which.exposed.dev)>0){
      for(d in 1:length(which.exposed.dev)){
        
        which.dev=which(dev.obj.dates$start <= dens$age.60d[which.exposed.dev[d]] & dev.obj.dates$end   >= dens$birth.date[which.exposed.dev[d]] )   #starts on or before 60d,  ends  on or after  birth  #more concise logical statement 

        exposed = 0
        count = 1
        while( count<=length(which.dev)){  
          if(inside.owin(dens.ppp[which.exposed.dev[d]]$x,dens.ppp[which.exposed.dev[d]]$y,dev.obj.list.buff[[which.dev[count]]])==T) {exposed=1; break }
          count = count+1
        } 
        #If den exposed to activity, then assign take
        if(exposed==1){
          dens$d2dev.early[which.exposed.dev[d]] = disturbance.distance.early
          take.level=which(rmultinom(1,1,prob.resp.early)==1) 
          if(take.level==4){                                                #no need to assign values, can be left as NA to save computing time, simplifies future which() statements, too
              dens$disturbed.early.Lethal[which.exposed.dev[d]] = 1
              dens$disturbed.early       [which.exposed.dev[d]] = 1
            }
          } else dens$d2dev.early[which.exposed.dev[d]] = 9999 #end if exposed
      } #end for d loop through exposed dens
    }
    ########################################################################################################################################################
    
    #Determine those disturbed by development during late denning period
    #Restrict to those that haven't had LevA or Lethal take yet
    not.detected=(!(Vectorize(isTRUE)(dens$detected.flir==1) & dens$age.60d > dens$detected.date))
    # which.exposed.dev = which(dens$exposed.dev==1 & not.detected==T & 
    #                             is.na(dens$disturbed.early.Lethal)  )
    which.exposed.dev = which(dens$exposed.dev==1 & (not.detected==T | (not.detected==F & dens$exposed.early.dev==1)) & #for Narwhal, only moving up to half mile, so anything within the "early denning" exposure will still be exposed, even if found by FLIR
                                is.na(dens$disturbed.early.Lethal)  )
    
    if(length(which.exposed.dev)>0){
      for(d in 1:length(which.exposed.dev)){
        
        which.dev=which(dev.obj.dates$start <= dens$emerge.date[which.exposed.dev[d]] & dev.obj.dates$end   >=  dens$age.60d[which.exposed.dev[d]]) #starts on or before emerge, ends on or after  60d       ##more concise logical statement 

        exposed = 0
        count = 1
        while( count<=length(which.dev)){  
          if(inside.owin(dens.ppp[which.exposed.dev[d]]$x,dens.ppp[which.exposed.dev[d]]$y,dev.obj.list.buff[[which.dev[count]]])==T) {exposed=1; break }
          count = count+1
        }
 
        #If den exposed to activity, then assign take, assign disturbed emergence date
        if(exposed==1){
          dens$d2dev.late[which.exposed.dev[d]] = disturbance.distance  
          
          which.dev=which.dev[count]  
          if(dev.obj.dates[which.dev,'start'] <= dens$age.60d[which.exposed.dev[d]]) 
            tmp.jd = dens$age.60d.jd[which.exposed.dev[d]] else            #if dev starts prior to late denning period set to beg of late denning period 
            tmp.jd = strptime(dev.obj.dates[which.dev,'start'],'%Y-%m-%d')$yd   #else set to dev starting date
          
          tmp.emerge = runif(1,tmp.jd,dens$emerge.jd[which.exposed.dev[d]])                                                                              #set emergence date to random value between disturbance and actual emergence
          tmp.year   = substr(dens$age.60d[which.exposed.dev[d]],1,4)
          tmp.emerge = strptime(paste(tmp.year,'-01-01',sep=''),'%Y-%m-%d') + (60*60*24)*tmp.emerge#converts to a new emergence date
          
          take.level=which(rmultinom(1,1,prob.resp.late)==1)        #no take

          if(take.level==2){                                        #lev B take
            dens$disturbed.late.LevB  [which.exposed.dev[d]] = 1
            dens$disturbed.late       [which.exposed.dev[d]] = 1
          } else if(take.level==3){                                 #levA take, new emergence date
            dens$disturbed.late.LevA  [which.exposed.dev[d]] = 1 
            dens$disturbed.late       [which.exposed.dev[d]] = 1
            #assign a new emergence date
            dens$disturbed.emerge.date[which.exposed.dev[d]] = tmp.emerge
          } else if(take.level==4){                                   #lethal take
            dens$disturbed.late.Lethal[which.exposed.dev[d]] = 1
            dens$disturbed.late       [which.exposed.dev[d]] = 1
          } 
        } else dens$d2dev.late[which.exposed.dev[d]] = 9999 #end if exposed==1
      } #end for d loop through exposed dens
    }  #end if length(which.exposed.dev)>0
    ########################################################################################################################################################
    
    #Determine those disturbed by development during post denning period
    #Restrict to those that haven't had LevA or Lethal take yet
    not.detected=(!(Vectorize(isTRUE)(dens$detected.flir==1)))   #much simpler logic statement equivalent to above ################Vectorize(isTRUE)
    
    # which.exposed.dev=which(dens$exposed.dev==1 & not.detected==T & 
    #                           Vectorize(isTRUE)(dens$disturbed.early.Lethal==0) &                                                    #using isTrue, will assign FALSE for any NAs
    #                           Vectorize(isTRUE)(dens$disturbed.late.Lethal ==0 )    )
    which.exposed.dev=which(dens$exposed.dev==1 &(not.detected==T | (not.detected==F & dens$exposed.early.dev==1)) & #for Narwhal, only moving up to half mile, so anything within the "early denning" exposure will still be exposed, even if found by FLIR 
                              Vectorize(isTRUE)(dens$disturbed.early.Lethal==0) &                                                    #using isTrue, will assign FALSE for any NAs
                              Vectorize(isTRUE)(dens$disturbed.late.Lethal ==0 )    )
    
    if(length(which.exposed.dev)>0){
      for(d in 1:length(which.exposed.dev)){
        
        #Which development were active during post emergence period for a given den if den did not emerge early
        if(is.na(dens$disturbed.emerge.date[which.exposed.dev[d]])){
           which.dev=which(dev.obj.dates$start <= dens$departure.date[which.exposed.dev[d]] & dev.obj.dates$end >= dens$emerge.date   [which.exposed.dev[d]])   #starts on or before depart,  ends on or after emerge                     #more concise logical statement 
        }else {                                                                                     #Which development were active during post emergence period for a given den that emerged
          which.dev=which(dev.obj.dates$start <= (dens$disturbed.emerge.date[which.exposed.dev[d]] + (60*60*24)*dens$time.at.den[which.exposed.dev[d]]) &  dev.obj.dates$end >= dens$disturbed.emerge.date[which.exposed.dev[d]])  #starts on or before new depart date,  ends on or after disturbed emerge date    #more concise logical statement 
        }
        
        exposed = 0
        count = 1
        while( count<=length(which.dev)){  
          if(inside.owin(dens.ppp[which.exposed.dev[d]]$x,dens.ppp[which.exposed.dev[d]]$y,dev.obj.list.buff[[which.dev[count]]])==T) {exposed=1; break }
          count = count+1
        } 

        #If den exposed to activity, then assign take
        if(exposed==1){
          dens$d2dev.post[which.exposed.dev[d]] = disturbance.distance
          
          if(is.na(dens$disturbed.late.LevA[which.exposed.dev[d]]) | dens$disturbed.late.LevA[which.exposed.dev[d]]==0) 
            take.level=which(rmultinom(1,1,prob.resp.post )==1) else 
            take.level=which(rmultinom(1,1,prob.resp.post2)==1)
            
            if(take.level==2){
              dens$disturbed.post.LevB  [which.exposed.dev[d]] = 1
              dens$disturbed.post       [which.exposed.dev[d]] = 1
            } else if(take.level==3){
              dens$disturbed.post.LevA  [which.exposed.dev[d]] = 1
              dens$disturbed.post       [which.exposed.dev[d]] = 1
              #Assign reduced time at den:
              tmp.tad = sample(0:(dens$time.at.den[which.exposed.dev[d]]-1),1) #set new TAD to be uniform (0,one day less) #will give integer values
              dens$disturbed.tad[which.exposed.dev[d]] = tmp.tad
              if(is.na(dens$disturbed.emerge.date[which.exposed.dev[d]]))
                dens$disturbed.dep.date[which.exposed.dev[d]] = dens$emerge.date          [which.exposed.dev[d]]+(60*60*24)*tmp.tad else
                dens$disturbed.dep.date[which.exposed.dev[d]] = dens$disturbed.emerge.date[which.exposed.dev[d]]+(60*60*24)*tmp.tad  
            } else if(take.level==4){
              dens$disturbed.post.Lethal[which.exposed.dev[d]] = 1
              dens$disturbed.post       [which.exposed.dev[d]] = 1
            }   
        } else dens$d2dev.post[which.exposed.dev[d]] = 9999 
      } #end for d loop through exposed dens
    }
    ########################################################################################################################################################

    tmp.coef = litter.surv.coef[sample(seq(1,nrow(litter.surv.coef),1),1),] #survival regression coefficients for this iteration
    
    #calculate litter survival probability given undisturbed emergence date and TAD
    tmp.p = exp(tmp.coef[1,1] +
                tmp.coef[1,2]*strptime(substr(dens$emerge.date,1,10),'%Y-%m-%d')$yd  +  
                tmp.coef[1,3]*dens$time.at.den)
    dens$P.Litter.Surv.undist = tmp.p/(1+tmp.p)
    
    
    #Summarize dens with early emergence or early departure and  calculate new litter survival probs 
    tmp.which = which(!is.na(dens$disturbed.emerge.date) | !is.na(dens$disturbed.tad))
    
    if(length(tmp.which)>0){
      for(t in 1:length(tmp.which)){
        if(is.na(dens$disturbed.emerge.date[tmp.which[t]])) 
          tmp.emerge = dens$emerge.date          [tmp.which[t]] else 
          tmp.emerge = dens$disturbed.emerge.date[tmp.which[t]]
          
        tmp.emerge.jd=strptime(substr(tmp.emerge,1,10),'%Y-%m-%d')$yd
        if(is.na(dens$disturbed.tad[tmp.which[t]])) 
          tmp.tad = dens$time.at.den  [tmp.which[t]] else 
          tmp.tad = dens$disturbed.tad[tmp.which[t]]
        
        tmp.p = exp(tmp.coef[1,1]+tmp.coef[1,2]*tmp.emerge.jd+tmp.coef[1,3]*tmp.tad)
        tmp.p = tmp.p/(1+tmp.p)
        dens$P.Litter.Surv.dist[tmp.which[t]] =tmp.p
      }
    }
    
    
    ###################
    #Summarize results
    ###################
    results.df$LevB.estab.bears   = sum(dens[,'disturbed.estab.LevB'  ],na.rm=T)
                                      
    results.df$Lethal.early.ndens = sum(dens[,'disturbed.early.Lethal'],na.rm=T)
    results.df$LevB.early.bears   = sum(dens[,'disturbed.early.Lethal'],na.rm=T)        #LevB of adult females
    results.df$Lethal.early.ncubs = sum(dens[,'disturbed.early.Lethal']*dens[,'littersize'],na.rm=T)
                                    
    results.df$LevB.late.bears    = sum(dens[,'disturbed.late.LevB'  ]*dens[,'littersize'],na.rm=T) +                                                                          #cubs
                                    sum(dens[,'disturbed.late.LevB'  ],na.rm=T) + sum(dens[,'disturbed.late.Lethal'],na.rm=T) + sum(dens[,'disturbed.late.LevA'],na.rm=T) #Adult female
    results.df$Lethal.late.ndens  = sum(dens[,'disturbed.late.Lethal'],na.rm=T)
    results.df$Lethal.late.ncubs  = sum(dens[,'disturbed.late.Lethal']*dens[,'littersize'],na.rm=T)
                                        
    results.df$LevB.post.bears    = sum(dens[,'disturbed.post.LevB'  ]*dens[,'littersize'],na.rm=T) +                                                                          #cubs
                                    sum(dens[,'disturbed.post.LevB'  ],na.rm=T) + sum(dens[,'disturbed.post.Lethal'],na.rm=T) + sum(dens[,'disturbed.post.LevA'],na.rm=T) #Adult female
    results.df$Lethal.post.ndens  = sum(dens[,'disturbed.post.Lethal'],na.rm=T)
    results.df$Lethal.post.ncubs  = sum(dens[,'disturbed.post.Lethal']*dens[,'littersize'],na.rm=T)
                                         
    results.df$LevA.late.ndens    = sum(dens[,'disturbed.late.LevA'  ],na.rm=T)
    results.df$LevA.late.ncubs    = sum(dens[,'disturbed.late.LevA'  ]*dens[,'littersize'],na.rm=T)
                                     
    results.df$LevA.post.ndens    = sum(dens[,'disturbed.post.LevA'  ],na.rm=T)
    results.df$LevA.post.ncubs    = sum(dens[,'disturbed.post.LevA'  ]*dens[,'littersize'],na.rm=T)
    
  
  results      = list()
  results[[1]] = dens
  results[[2]] = results.df
  if(FLIR==T) {results[[3]] = FLIR.date}
  return(results)
}#end of function
